﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using FDK;

namespace StrokeStyleT
{
	class CAct演奏チップ : CActivity
	{
		public CAct演奏パッド Act演奏パッド;
		public CAct演奏チップファイア Act演奏チップファイア;
		public CAct演奏判定文字列 Act演奏判定文字列;
		public CAct演奏コンボ Act演奏コンボ;
		public CAct演奏ビッグファイア Act演奏ビッグファイア;
		public CAct演奏背景動画 Act演奏背景動画;

		public CAct演奏チップ()
		{
			this.list子Activities.Add( this.Act英数字描画 = new CAct英数字描画() );
			this.list子Activities.Add( this.Act演奏パッド = new CAct演奏パッド() );
			this.list子Activities.Add( this.Act演奏チップファイア = new CAct演奏チップファイア() );
			this.list子Activities.Add( this.Act演奏判定文字列 = new CAct演奏判定文字列() );
			this.list子Activities.Add( this.Act演奏コンボ = new CAct演奏コンボ() );
			this.list子Activities.Add( this.Act演奏ビッグファイア = new CAct演奏ビッグファイア() );
			this.list子Activities.Add( this.Act演奏背景動画 = new CAct演奏背景動画() );
		}

		public override void On活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してる )
				return;
			//-----------------
			#endregion

			this.ctチップアニメ = new CCounter( 0, 48, 10 );
			this.chip背景動画 = null;	// この時点で分かるとは限らない。進行が始まったあとに探すことにする。

			base.On活性化();
		}
		public override void On非活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.ctチップアニメ );

			base.On非活性化();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.txチップ = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay chips.png" ) );

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.txチップ );
			Global.tDisposeする( this.ctチップアニメ );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			throw new InvalidOperationException( "別の引数付きオーバーライドメソッドを使用すること。" );
		}
		public override void On描画( IntPtr hDevice )
		{
			throw new InvalidOperationException( "別の引数付きオーバーライドメソッドを使用すること。" );
		}

		public int On進行・背景動画()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return 0;

			if( Global.Stage.演奏 == null ||
				Global.Stage.演奏.b演奏終了済み )
				return 0;
			//-----------------
			#endregion

			#region [ 背景動画チップをまだ探してないなら、探して this.chip背景動画 に格納しておく。]
			//-----------------
			if( this.chip背景動画 == null )
			{
				foreach( var chip in Global.Song.r現在演奏中の曲のスコア.listチップ )
				{
					if( chip.eチップ == Eチップ.背景動画 )
					{
						this.chip背景動画 = chip;
						break;		// 見つけた
					}
				}
			}
			if( this.chip背景動画 == null )
				return 0;	// 背景動画チップがなかった
			//-----------------
			#endregion

			#region [ 背景動画チップ(this.chip背景動画) がヒットバーの位置に来たら再生開始する。]
			//-----------------
			if( this.chip背景動画 != null )
			{
				// n距離px = ヒットバーとチップの距離[pixel;符号付き]を算出する。
				// ・背景動画チップにはチップシフトは反映されない。
				// ・背景動画チップの再生遅延は、チップを移動することで既に反映済み → C演奏ステージ.On活性化()参照。
				
				int n距離px = Global.Song.r現在演奏中の曲のスコア.n指定された時間msに対応する符号付きピクセル数を返す( Global.SoundTimer.n現在時刻ms - this.chip背景動画.n発声時刻ms );

				
				// チップのY座標を算出する。

				int y = Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px + n距離px;

				// 背景動画チップ(this.chip背景動画) のヒット判定と処理。

				if( y >= -20 )	// y が画面上外に出ていれば無視。-20 は適当なマージン
				{
					if( this.chip背景動画.b未ヒット && n距離px >= 0 )
					{
						Global.Song.r現在演奏中のスコアの背景動画.t再生する( 0 );
						Global.Song.r現在演奏中のスコアのBGM.t先頭から再生する();

						this.chip背景動画.bヒット済 = true;
						this.chip背景動画.b可視 = false;
					}
				}
			}
			//-----------------
			#endregion

			if( this.chip背景動画 != null && this.chip背景動画.bヒット済 )
				this.Act演奏背景動画.On進行();

			return 0;
		}
		public void On描画・背景動画( IntPtr hDevice, CAct演奏背景動画.E種別 e種別 )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			
			if(	Global.Stage.演奏 == null ||
				Global.Stage.演奏.b演奏終了済み )
				return;
			//-----------------
			#endregion

			if( e種別 == CAct演奏背景動画.E種別.サムネイル )
				this.Act演奏背景動画.On描画( hDevice, CAct演奏背景動画.E種別.サムネイル枠 );

			if( this.chip背景動画 == null || this.chip背景動画.b未ヒット )	// チップが未ヒット時も描画無し。
				return;

			this.Act演奏背景動画.On描画( hDevice, e種別 );
		}

		public int On進行・コンボ()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return 0;
			//-----------------
			#endregion

			return this.Act演奏コンボ.On進行();
		}
		public void On描画・コンボ( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.Act演奏コンボ.On描画( hDevice );
		}

		public int On進行・小節線拍線()
		{
			return 0;
		}
		public void On描画・小節線拍線( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;

			if(	this.txチップ == null ||
				Global.Song.r現在演奏中の曲のスコア == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ.Count == 0 ||
				Global.Stage.演奏.b演奏終了済み )
				return;
			//-----------------
			#endregion

			var Score = Global.Song.r現在演奏中の曲のスコア;
			for( int i = Global.Stage.演奏.n描画開始チップ番号; i < Score.listチップ.Count; i++ )
			{
				var cc = Score.listチップ[ i ];

				// チップが描画対象じゃないならスキップ。

				if( cc.eチップ != Eチップ.小節線 && cc.eチップ != Eチップ.拍線 )
					continue;


				// 時間差を求める。

				long n描画時間差ms = Global.SoundTimer.n現在時刻ms
					- ( cc.n描画時刻ms + Global.Stage.演奏.n曲固有遅延差分の演奏中の変動量ms );	// 描画時刻 ＋ ⊿(2)


				// ヒットバーとチップの距離[pixel;符号付き]を算出する。

				int n描画距離px = Score.n指定された時間msに対応する符号付きピクセル数を返す( n描画時間差ms );


				// チップのY座標を算出する。y が画面上外に出ていればそこでループ終了。

				int y = Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px + n描画距離px;
				if( y < -20 )	// -20 は適当なマージン。
					break;


				// チップを描画する。

				if( cc.b可視 )
					this.tチップを描画する( hDevice, cc.eチップ, y, Cチップ.n最大音量 );


				// 小節番号を描画する。

				if( cc.eチップ == Eチップ.小節線 )
				{
					int x = Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.LeftCymbal ].X + 364 + 4;
					this.Act英数字描画.t表示( hDevice, x, y - 40, CAct英数字描画.E種別.白太, cc.n小節番号.ToString() );
				}
			}
		}

		public int On進行・ドラムチップ()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return 0;

			if( Global.Song.r現在演奏中の曲のスコア == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ.Count == 0 ||
				Global.Stage.演奏.b演奏終了済み )
				return 0;
			//-----------------
			#endregion

			var Score = Global.Song.r現在演奏中の曲のスコア;
			this.ctチップアニメ.t進行Loop();

			for( int i = Global.Stage.演奏.n描画開始チップ番号; i < Score.listチップ.Count; i++ )
			{
				var cc = Score.listチップ[ i ];

				#region [ チップが描画対象じゃないならスキップ。]
				//-----------------
				if( cc.eチップ == Eチップ.BPM ||
					cc.eチップ == Eチップ.小節線 ||
					cc.eチップ == Eチップ.拍線 ||
					cc.eチップ == Eチップ.背景動画 ||
					cc.eチップ == Eチップ.小節メモ ||
					cc.eチップ == Eチップ.Unknown )
					continue;
				//-----------------
				#endregion


				// 時間差を算出する。

				long n描画時間差ms = Global.SoundTimer.n現在時刻ms
					- ( cc.n描画時刻ms + Global.Stage.演奏.n曲固有遅延差分の演奏中の変動量ms );	// 描画時刻 + ⊿(2)

				long n発声時間差ms = Global.SoundTimer.n現在時刻ms
					- ( cc.n発声時刻ms + Global.Stage.演奏.n曲固有遅延差分の演奏中の変動量ms );	// 発声時刻 + ⊿(2)


				// Missチェック。

				#region [ ドラムチップについて、描画時間差 が PoorRange を正方向に超えているなら Miss を発火。]
				//-----------------
				if( this.bドラムチップである( cc ) &&
					cc.b未ヒット &&
					n描画時間差ms > Global.User.Config.PoorRange )
				{
					if( cc.eチップ == Eチップ.Snare_Ghost || cc.eチップ == Eチップ.HiHat_Foot )
					{
						// スネアゴーストとフットペダルについては、Miss 判定を行わない。
					}
					else
					{
						// 判定文字列(MISS)表示。
						var pad = Global.Stage.演奏.tチップが属する演奏レーンを返す( cc );
						this.Act演奏判定文字列.t表示( pad, E判定.MISS );	// 判定：MISS

						// COMBOリセット。
						this.Act演奏コンボ.nCOMBO値 = 0;
					}
					cc.bヒット済 = true;
				}
				//-----------------
				#endregion


				// 判定バーとチップの距離[pixel;符号付き]を算出する。

				int n発声距離px = Score.n指定された時間msに対応する符号付きピクセル数を返す( n発声時間差ms );
				int n描画距離px = Score.n指定された時間msに対応する符号付きピクセル数を返す( n描画時間差ms );


				// チップのY座標を算出する。y が画面上外に出ていればそこでループ終了。

				int y = Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px + n描画距離px;
				if( y < -20 )	// -20 は適当なマージン
					break;


				// オートチップの自動発声処理。

				if( cc.b未発声 && n発声距離px >= 0 )
				{
					#region [ AutoPlay なら発声処理をする。]
					//-----------------
					foreach( var padObj in Enum.GetValues( typeof( E演奏レーン ) ) )
					{
						E演奏レーン pad = (E演奏レーン) padObj;

						if( ( Global.User.Config.AutoPlayLeftCymbal && pad == E演奏レーン.LeftCymbal ) ||
							( Global.User.Config.AutoPlayFootPedal && pad == E演奏レーン.FootPedal ) ||
							( Global.User.Config.AutoPlayHiHat && pad == E演奏レーン.HiHat ) ||
							( Global.User.Config.AutoPlaySnare && pad == E演奏レーン.Snare ) ||
							( Global.User.Config.AutoPlayTom1 && pad == E演奏レーン.Tom1 ) ||
							( Global.User.Config.AutoPlayBass && pad == E演奏レーン.Bass ) ||
							( Global.User.Config.AutoPlayTom2 && pad == E演奏レーン.Tom2 ) ||
							( Global.User.Config.AutoPlayTom3 && pad == E演奏レーン.Tom3 ) ||
							( Global.User.Config.AutoPlayRightCymbal && pad == E演奏レーン.RightCymbal ) )
						{
							if( Global.Stage.演奏.dic演奏レーンtoチップ[ pad ].Contains( cc.eチップ ) )
							{
								// 仮想ドラムサウンド再生開始。

								if( Global.User.Config.HitSound )
									Global.VirtualDrums.tドラムサウンドを再生する( cc.eチップ, cc.n音量 );

								cc.b発声済 = true;
							}
						}
					}
					//-----------------
					#endregion
				}

				if( cc.b未ヒット && n描画距離px >= 0 )
				{
					#region [ AutoPlay ならヒット処理をする。]
					//-----------------
					foreach( var obj in Enum.GetValues( typeof( E演奏レーン ) ) )
					{
						E演奏レーン lane = (E演奏レーン) obj;

						if( ( Global.User.Config.AutoPlayLeftCymbal && lane == E演奏レーン.LeftCymbal ) ||
							( Global.User.Config.AutoPlayFootPedal && lane == E演奏レーン.FootPedal ) ||
							( Global.User.Config.AutoPlayHiHat && lane == E演奏レーン.HiHat ) ||
							( Global.User.Config.AutoPlaySnare && lane == E演奏レーン.Snare ) ||
							( Global.User.Config.AutoPlayTom1 && lane == E演奏レーン.Tom1 ) ||
							( Global.User.Config.AutoPlayBass && lane == E演奏レーン.Bass ) ||
							( Global.User.Config.AutoPlayTom2 && lane == E演奏レーン.Tom2 ) ||
							( Global.User.Config.AutoPlayTom3 && lane == E演奏レーン.Tom3 ) ||
							( Global.User.Config.AutoPlayRightCymbal && lane == E演奏レーン.RightCymbal ) )
						{
							if( Global.Stage.演奏.dic演奏レーンtoチップ[ lane ].Contains( cc.eチップ ) )
							{
								// AUTOヒットした

								if( cc.eチップ != Eチップ.Snare_Ghost && cc.eチップ != Eチップ.HiHat_Foot ) // Snare_Ghost と FootPedal はヒット対象としない。Missにもならない。
								{
									this.Act演奏パッド.tヒット( lane );					// パッドアニメ開始。
									this.Act演奏チップファイア.t発火( lane, 0 );		// チップファイア発火。
									if( this.Act演奏ビッグファイア.b発火する( cc ) )
										this.Act演奏ビッグファイア.t発火();				// ビッグファイア発火。

									this.Act演奏判定文字列.t表示( lane, E判定.AUTO );	// 判定文字列(AUTO)表示。
									Global.Stage.演奏.dicヒットした回数[ E判定.AUTO ]++;// 判定別ヒット回数の増加。
									if( Global.User.Config.b全オートである )
										this.Act演奏コンボ.nCOMBO値++;					// 全AUTOのときだけCOMBO増加。
								}

								cc.bヒット済 = true;
								cc.b可視 = false;
							}
						}
					}
					//-----------------
					#endregion
				}
			}

			return 0;
		}
		public void On描画・ドラムチップ( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;

			if( this.txチップ == null ||
				Global.Song.r現在演奏中の曲のスコア == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ.Count == 0 ||
				Global.Stage.演奏.b演奏終了済み )
				return;
			//-----------------
			#endregion

			var Score = Global.Song.r現在演奏中の曲のスコア;
			for( int i = Global.Stage.演奏.n描画開始チップ番号; i < Score.listチップ.Count; i++ )
			{
				var cc = Score.listチップ[ i ];

				#region [ チップが描画対象じゃないならスキップ。]
				//-----------------
				if( cc.eチップ == Eチップ.BPM ||
					cc.eチップ == Eチップ.小節線 ||
					cc.eチップ == Eチップ.拍線 ||
					cc.eチップ == Eチップ.背景動画 ||
					cc.eチップ == Eチップ.小節メモ ||
					cc.eチップ == Eチップ.Unknown )
					continue;
				//-----------------
				#endregion


				// 時間差を算出する。

				long n描画時間差ms = Global.SoundTimer.n現在時刻ms
					- ( cc.n描画時刻ms + Global.Stage.演奏.n曲固有遅延差分の演奏中の変動量ms );	// 描画時刻 + ⊿(2)


				// ヒットバーとチップの距離[pixel;符号付き]を算出する。

				int n描画距離px = Score.n指定された時間msに対応する符号付きピクセル数を返す( n描画時間差ms );


				// チップのY座標を算出する。y が画面上外に出ていればそこでループ終了。

				int y = ( Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px ) + n描画距離px;
				if( y < -20 )	// -20 は適当なマージン
					break;


				// チップを描画する。

				if( cc.b可視 )
					this.tチップを描画する( hDevice, cc.eチップ, y, cc.n音量 );
			}
		}

		/// <summary>
		/// <para>該当するチップが見つかった場合は、e判定 に判定結果を、yチップ にチップのY座標を格納し、そのチップを戻り値として返す。</para>
		/// <para>該当するチップが見つからなかった場合は、e判定に MISS を、yチップ に 0 を格納し、戻り値として null を返す。</para>
		/// <para>※ eパッドについて、Eパッド.ハイハット上／下は同等とみなされる。</para>
		/// <para>※ スネアゴーストは無視する。</para>
		/// </summary>
		public Cチップ t指定されたパッドラインと時刻でヒットしたチップを返す( Cスコア score, E演奏レーン eパッド, long n入力時刻ms, out E判定 e判定, out int yチップ )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( Global.Song.r現在演奏中の曲のスコア == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ.Count == 0 ||
				Global.Stage.演奏.n描画開始チップ番号 < 0 )
			{
				e判定 = E判定.MISS;
				yチップ = 0;
				return null;
			}
			//-----------------
			#endregion

			// 描画開始チップ以降のすべてのチップについて...
			for( int i = Global.Stage.演奏.n描画開始チップ番号; i < score.listチップ.Count; i++ )
			{
				var cc = score.listチップ[ i ];


				// チップがヒットチェック対象じゃなければスキップする。

				if( cc.bヒット済 ||								// ヒット済みならスキップ。
					cc.eチップ == Eチップ.Snare_Ghost ||		// Snare_Ghost もスキップ。
					!Global.Stage.演奏.dic演奏レーンtoチップ[ eパッド ].Contains( cc.eチップ ) )	// パッドに対応するチップじゃなかったらスキップ。
					continue;


				// 時間差を算出する。

				long n時間差ms = n入力時刻ms
					- ( cc.n描画時刻ms + Global.Stage.演奏.n曲固有遅延差分の演奏中の変動量ms );	// 描画時刻 + ⊿(2)


				// ヒットバーとチップの距離[pixel;符号付き]を算出する。

				int n距離px = score.n指定された時間msに対応する符号付きピクセル数を返す( n時間差ms );


				// チップのY座標を算出する。y が画面上外に出ていればそこでループ終了。

				int y = ( Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px ) + n距離px;
				if( y < -20 )	// -20 は適当なマージン
					break;


				// ヒットチェック。

				n時間差ms = Math.Abs( n時間差ms );

				if( n時間差ms <= Global.User.Config.PerfectRange )
				{
					e判定 = E判定.PERFECT;
					yチップ = y;
					return cc;
				}
				if( n時間差ms <= Global.User.Config.GreatRange )
				{
					e判定 = E判定.GREAT;
					yチップ = y;
					return cc;
				}
				if( n時間差ms <= Global.User.Config.GoodRange )
				{
					e判定 = E判定.GOOD;
					yチップ = y;
					return cc;
				}
				if( n時間差ms <= Global.User.Config.PoorRange )
				{
					e判定 = E判定.POOR;
					yチップ = y;
					return cc;
				}
			}

			// 該当チップがなかった

			e判定 = E判定.MISS;
			yチップ = 0;
			return null;
		}

		CAct英数字描画 Act英数字描画;
		CTexture txチップ;
		CCounter ctチップアニメ;
		Cチップ chip背景動画;

		void tチップを描画する( IntPtr hDevice, Eチップ eチップ, int nチップのY座標, int nチップの音量 )
		{
			int chipY = this.ctチップアニメ.n現在の値 * 10;
			float vy = 1.25f;
			Rectangle rcPad;

			switch( eチップ )
			{
				case Eチップ.LeftCrash:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.LeftCymbal ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 285, 0, 110, 45 ) );
					break;

				case Eチップ.HiHat_Close:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.HiHat ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 57, chipY, 48, 13 ) );
					break;

				case Eチップ.HiHat_HalfOpen:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.HiHat ].X, nチップのY座標, 0.8f, vy, nチップの音量, new Rectangle( 57, chipY, 48, 13 ) );
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.FootPedal ].X, nチップのY座標, 1.0f, 1.0f, nチップの音量, new Rectangle( 340, 315, 55, 45 ) );
					break;

				case Eチップ.HiHat_Open:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.HiHat ].X, nチップのY座標, 0.8f, vy, nチップの音量, new Rectangle( 57, chipY, 48, 13 ) );
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.FootPedal ].X, nチップのY座標, 1.0f, 1.0f, nチップの音量, new Rectangle( 285, 315, 55, 45 ) );
					break;

				case Eチップ.HiHat_Foot:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.FootPedal ].X, nチップのY座標, 1.0f, 1.0f, nチップの音量, new Rectangle( 395, 315, 55, 45 ) );
					break;

				case Eチップ.Snare:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Snare ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 102, chipY, 48, 13 ) );
					break;

				case Eチップ.Snare_ClosedRim:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Snare ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 285, 270, 55, 45 ) );
					break;

				case Eチップ.Snare_OpenRim:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Snare ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 395, 270, 110, 45 ) );
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Snare ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 102, chipY, 48, 13 ) );
					break;

				case Eチップ.Snare_Ghost:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Snare ].X, nチップのY座標, 1.0f, 1.0f, nチップの音量, new Rectangle( 340, 270, 55, 45 ) );
					break;

				case Eチップ.Bass:
					// Bass は縦倍率を他より少し大きくする。
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Bass ].X, nチップのY座標, 1.0f, 1.75f, nチップの音量, new Rectangle( 0, chipY, 60, 13 ) );
					break;

				case Eチップ.Tom1:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom1 ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 147, chipY, 48, 13 ) );
					break;

				case Eチップ.Tom1_Rim:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom1 ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 285, 270, 55, 45 ) );
					break;

				case Eチップ.Tom2:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom2 ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 192, chipY, 48, 13 ) );
					break;

				case Eチップ.Tom2_Rim:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom2 ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 285, 270, 55, 45 ) );
					break;

				case Eチップ.Tom3:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom3 ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 237, chipY, 48, 13 ) );
					break;

				case Eチップ.Tom3_Rim:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.Tom3 ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 285, 270, 55, 45 ) );
					break;

				case Eチップ.RightCrash:
					this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.RightCymbal ].X, nチップのY座標, 1.0f, vy, nチップの音量, new Rectangle( 395, 0, 110, 45 ) );
					break;

				case Eチップ.China:
					{
						var eレーン = ( Global.User.Config.ChinaLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal;
						rcPad = ( Global.User.Config.ChinaLeft ) ? new Rectangle( 285, 180, 110, 45 ) : new Rectangle( 395, 180, 110, 45 );
						this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X, nチップのY座標, 1.0f, vy, nチップの音量, rcPad );
					}
					break;

				case Eチップ.Ride:
					{
						var eレーン = ( Global.User.Config.RideLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal;
						rcPad = ( Global.User.Config.RideLeft ) ? new Rectangle( 285, 90, 110, 45 ) : new Rectangle( 395, 90, 110, 45 );
						this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X, nチップのY座標, 1.0f, vy, nチップの音量, rcPad );
					}
					break;

				case Eチップ.Ride_Cup:
					{
						var eレーン = ( Global.User.Config.RideLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal;
						rcPad = ( Global.User.Config.RideLeft ) ? new Rectangle( 285, 135, 110, 45 ) : new Rectangle( 395, 135, 110, 45 );
						this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X, nチップのY座標, 1.0f, vy, nチップの音量, rcPad );
					}
					break;

				case Eチップ.Splash:
					{
						var eレーン = ( Global.User.Config.SplashLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal;
						rcPad = ( Global.User.Config.SplashLeft ) ? new Rectangle( 285, 45, 110, 45 ) : new Rectangle( 395, 45, 110, 45 );
						this.tチップを描画する( hDevice, Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X, nチップのY座標, 1.0f, vy, nチップの音量, rcPad );
					}
					break;

				case Eチップ.小節線:
					this.txチップ.vc拡大縮小倍率 = new Vector3( 1f, 1f, 1f );
					this.txチップ.t2D描画(
						hDevice,
						new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.LeftCymbal ].X, nチップのY座標 - 1 ),
						new Rectangle( 0, 493, 364, 2 ) );
					break;

				case Eチップ.拍線:
					this.txチップ.vc拡大縮小倍率 = new Vector3( 1f, 1f, 1f );
					this.txチップ.t2D描画(
						hDevice,
						new Point( Theme.演奏.dicパッドの中心スクリーン座標px[ E演奏レーン.LeftCymbal ].X, nチップのY座標 - 1 ),
						new Rectangle( 0, 495, 364, 2 ) );
					break;
			}
		}
		void tチップを描画する( IntPtr hDevice, int n中央X, int n中央Y, float f拡大率X, float f拡大率Y, int nチップの音量, Rectangle rcチップ画像領域 )
		{
			// 音量により縦方向の拡大率を変更。

			float f縮小率 = (float) nチップの音量 * ( 1.0f / ( Cチップ.n最大音量 - Cチップ.n最小音量 + 1 ) );	// 0.0～1.0
			f拡大率Y *= f縮小率;


			// 拡大率を設定。

			this.txチップ.vc拡大縮小倍率 = new Vector3( f拡大率X, f拡大率Y, 1.0f );


			// チップを描画。

			this.txチップ.t2D描画(
				hDevice,
				n中央X - (int) ( ( rcチップ画像領域.Width * f拡大率X ) / 2.0f ),
				n中央Y - (int) ( ( rcチップ画像領域.Height * f拡大率Y ) / 2.0f ),
				rcチップ画像領域 );
		}
		bool bドラムチップである( Cチップ cc )
		{
			return
				cc.eチップ != Eチップ.Snare_Ghost &&		// Snare_Ghost は判定対象にはしない。Miss にもならない。
				cc.eチップ != Eチップ.BPM &&
				cc.eチップ != Eチップ.Unknown &&
				cc.eチップ != Eチップ.小節線 &&
				cc.eチップ != Eチップ.背景動画 &&
				cc.eチップ != Eチップ.拍線 &&
				cc.eチップ != Eチップ.小節メモ;
		}
	}
}
